﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
''' <summary>
''' 窗体坐标将左上角作为 (0,0)。对于游戏网格，
''' 将网格的左下角作为 (0,0) 更容易。这样
''' 就需要转换点。
''' </summary>
''' <remarks></remarks>
Public Class PointTranslator

    Private Shared graphicsValue As Graphics
    Private Shared height As Integer

    Public Shared Property Graphics() As Graphics
        Get
            Return graphicsValue
        End Get
        Set(ByVal Value As Graphics)
            graphicsValue = Value
            height = CInt(graphicsValue.VisibleClipBounds.Height())
        End Set
    End Property

    ' 将一个从左上角开始的 (X,Y) 点转换为从左下角开始的 (X, Y) 点。
    Public Shared Function TranslateToBL(ByVal topleft As Point) As Point
        Dim newPoint As Point
        newPoint.X = topleft.X
        newPoint.Y = height - topleft.Y
        Return newPoint
    End Function

    Public Shared Function TranslateToTL(ByVal bottomleft As Point) As Point
        Dim newPoint As Point
        newPoint.X = bottomleft.X
        newPoint.Y = height - bottomleft.Y
        Return newPoint
    End Function
End Class
